/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.http.entity.ContentType;

public enum ContentTypeAndFileExtensions {
    MIME_TYPE_JPG(ContentType.create((String)"image/jpeg", (Charset)null), false, true, ".jpg", ".jpeg"),
    MIME_TYPE_ICO(ContentType.create((String)"image/vnd.microsoft.icon", (Charset)null), false, true, ".ico"),
    MIME_TYPE_MPEG(ContentType.create((String)"audio/mpeg", (Charset)null), false, true, ".mpg", ".mpeg", ".mp3"),
    MIME_TYPE_WAV(ContentType.create((String)"audio/wav", (Charset)null), false, true, ".wav"),
    MIME_TYPE_FLAC(ContentType.create((String)"audio/flac", (Charset)null), false, true, ".flac"),
    MIME_TYPE_AAC(ContentType.create((String)"audio/aac", (Charset)null), false, true, ".aac"),
    MIME_TYPE_SID(ContentType.create((String)"audio/prs.sid", (Charset)null), false, true, ".sid"),
    MIME_TYPE_FLV(ContentType.create((String)"video/x-flv", (Charset)null), false, true, ".flv", ".f4v"),
    MIME_TYPE_AVI(ContentType.create((String)"video/msvideo", (Charset)null), false, true, ".avi"),
    MIME_TYPE_MP4(ContentType.create((String)"video/mp4", (Charset)null), false, true, ".mp4"),
    MIME_TYPE_OCTET_STREAM(ContentType.create((String)"application/octet-stream", (Charset)null), false, true, ".bin"),
    MIME_TYPE_TEXT(ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8), true, false, ".txt"),
    MIME_TYPE_CSV(ContentType.create((String)"text/csv", (Charset)null), true, false, ".csv"),
    MIME_TYPE_JSON(ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8), true, false, ".json"),
    MIME_TYPE_XML(ContentType.create((String)"application/xml", (Charset)StandardCharsets.UTF_8), true, false, ".xml"),
    MIME_TYPE_MULTIPART(ContentType.create((String)"multipart/form-data", (Charset)StandardCharsets.UTF_8), false, false, ".bin"),
    MIME_TYPE_FORM_URLENCODED(ContentType.create((String)"application/x-www-form-urlencoded", (Charset)StandardCharsets.UTF_8), false, false, ".bin"),
    MIME_TYPE_HTML(ContentType.create((String)"text/html", (Charset)StandardCharsets.UTF_8), true, true, ".html", ".vue"),
    MIME_TYPE_JAVASCRIPT(ContentType.create((String)"application/javascript", (Charset)StandardCharsets.UTF_8), true, true, ".js"),
    MIME_TYPE_SCSS(ContentType.create((String)"text/css", (Charset)StandardCharsets.UTF_8), true, true, ".scss", ".css"),
    MIME_TYPE_WOFF2(ContentType.create((String)"font/woff2", (Charset)null), false, true, ".woff2"),
    MIME_TYPE_WOFF(ContentType.create((String)"font/woff", (Charset)null), false, true, ".woff"),
    WASM(ContentType.create((String)"application/wasm", (Charset)null), false, true, ".wasm");

    private final ContentType contentType;
    private boolean isText;
    private boolean isCacheable;
    private final String[] extensions;

    private ContentTypeAndFileExtensions(ContentType contentType, boolean isText, boolean isCacheable, String ... extensions) {
        this.contentType = contentType;
        this.isText = isText;
        this.isCacheable = isCacheable;
        this.extensions = extensions;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public String getMimeType() {
        return this.contentType.getMimeType();
    }

    public Charset getCharset() {
        return this.contentType.getCharset();
    }

    public boolean isText() {
        return this.isText;
    }

    public boolean isCacheable() {
        return this.isCacheable;
    }

    public String toString() {
        return this.contentType.toString();
    }

    public boolean isCompatible(String headerValue) {
        ContentType otherContentType = ContentType.parse((String)headerValue);
        if (otherContentType.getCharset() != null) {
            return Objects.equals(this.getCharset(), otherContentType.getCharset()) && Objects.equals(this.getMimeType(), otherContentType.getMimeType());
        }
        return Objects.equals(this.getMimeType(), otherContentType.getMimeType());
    }

    public static ContentTypeAndFileExtensions getMimeType(String extension) {
        return Arrays.asList(ContentTypeAndFileExtensions.values()).stream().filter(ct -> extension != null && Arrays.asList(ct.getExtensions()).contains(extension.toLowerCase(Locale.ENGLISH))).findFirst().orElse(MIME_TYPE_OCTET_STREAM);
    }
}

